<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('monthly_due_payments', function (Blueprint $table) {
            $table->id();
            $table->string('amount');
            $table->string('province');
            $table->string('paymentDate');
            $table->string('provinceCoordinator');
            $table->string('refMonth');
            $table->string('whoPaid');
            $table->string('remark');
            $table->dateTime('createdDate')->useCurrent();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monthly_due_payments');
    }
};
