<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('national_reports', function (Blueprint $table) {
            $table->id();
            $table->string('core_duties');
            $table->string('monthly_task');
            $table->string('task_done');
            $table->string('strength');
            $table->string('weakness');
            $table->string('opportunities')->nullable();
            $table->string('threats')->nullable();
            $table->string('amount_budgeted');
            $table->string('amount_spent');
            $table->string('remarks')->nullable();
            $table->dateTime('created_date')->useCurrent();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('national_reports');
    }
};
