<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('monthly_reports', function (Blueprint $table) {
            $table->id();
            $table->string('state');
            $table->string('region');
            $table->string('province');
            $table->string('coordinator_name');
            $table->string('prison_visited')->nullable();
            $table->string('hospital_visited')->nullable();
            $table->string('police_station_visited')->nullable();
            $table->string('others')->nullable();
            $table->text('items');
            $table->string('amount_budgeted')->nullable();
            $table->string('amount_spent');
            $table->text('team_members');
            $table->string('souls_won');
            $table->string('challenges');
            $table->string('suggestion')->nullable();
            $table->string('remarks');
            $table->string('report_created_by');
            $table->string('activity_date');
            $table->dateTime('created_date')->useCurrent();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monthly_reports');
    }
};
