<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('national_d_b_user_profiles', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('first_name');
            $table->string('others')->nullable();
            $table->string('last_name');
            $table->string('email')->unique();
            $table->enum('gender', ['MALE', 'FEMALE']);
            $table->string('region');
            $table->string('province');
            $table->string('zone');
            $table->string('area');
            $table->string('parish');
            $table->string('state');
            $table->string('lga');
            $table->string('city');
            $table->enum('position', ['NATIONAL EXCO', 'REG COORDINATOR', 'PROV COORDINATOR', 'ASST REG COORDINATOR', 'ASST PROV COORDINATOR', 'MEMBER']);
            $table->string('join_ministry');
            $table->string('occupation');
            $table->string('industry');
            $table->string('dob');
            $table->string('phone_whatsapp');
            $table->string('social_handle')->nullable()->unique();
            $table->text('address_home');
            $table->string('nearest_busstop')->nullable();
            $table->string('address_office');
            $table->string('next_of_kin');
            $table->string('next_of_kin_phone');
            $table->string('image_path')->nullable();
            $table->enum('ordination_category', ['NOT ORDAINED', 'DEACON', 'DEACONESS', 'ASST PASTOR', 'FULL PASTOR']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('national_d_b_user_profiles');
    }
};
