<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

/**
 * The User model representing authenticated application users.
 */
class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * Since `$guarded` is empty, all fields are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden when the model is serialized (e.g., API response).
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime', // Automatically cast this field to a Carbon date object
            'password' => 'hashed',            // Hash the password automatically when set
        ];
    }

    /**
     * Check if the user is a Super Admin.
     *
     * @return bool
     */
    public function isSuperAdmin(): bool
    {
        return $this->role === 'SUPER_ADMIN';
    }

    /**
     * Check if the user is an Admin or Super Admin.
     *
     * @return bool
     */
    public function isAdmin(): bool
    {
        return in_array($this->role, ['ADMIN', 'SUPER_ADMIN']);
    }

    /**
     * Check if the user has Secretary-level access (Admin, Super Admin, or Secretary).
     *
     * @return bool
     */
    public function isSecretary(): bool
    {
        return in_array($this->role, ['ADMIN', 'SUPER_ADMIN', 'SECRETARY']);
    }

    /**
     * Check if the user has Treasurer-level access (Admin, Super Admin, or Treasurer).
     *
     * @return bool
     */
    public function isTreasurer(): bool
    {
        return in_array($this->role, ['ADMIN', 'SUPER_ADMIN', 'TREASURER']);
    }

    /**
     * Check if the user has general User-level access (Admin, Super Admin, or User).
     *
     * @return bool
     */
    public function isUser(): bool
    {
        return in_array($this->role, ['ADMIN', 'SUPER_ADMIN', 'USER']);
    }
}
