<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
    use Illuminate\Validation\Rule;

class UpdateNationalDBUserProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

     private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
     private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';

    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */

public function rules(): array
{
    return [
        'title' => 'required|string|max:50',
        'first_name' => self::REQUIRED_STRING_MAX_255,
        'last_name' => self::REQUIRED_STRING_MAX_255,
        'others' => self::NULLABLE_STRING_MAX_255,
        'email' => [
            'required', 'email',
            Rule::unique('national_d_b_user_profiles', 'email')->ignore($this->route('id')),
        ],
        'gender' => 'required|in:MALE,FEMALE',
        'region' => self::NULLABLE_STRING_MAX_255,
        'province' => self::NULLABLE_STRING_MAX_255,
        'zone' => self::NULLABLE_STRING_MAX_255,
        'area' => self::NULLABLE_STRING_MAX_255,
        'parish' => self::NULLABLE_STRING_MAX_255,
        'state' => self::REQUIRED_STRING_MAX_255,
        'lga' => self::NULLABLE_STRING_MAX_255,
        'city' => self::REQUIRED_STRING_MAX_255,
        'position' => self::REQUIRED_STRING_MAX_255,
        'join_ministry' => 'required|string',
        'occupation' => self::NULLABLE_STRING_MAX_255,
        'dob' => 'required|string',
        'phone_whatsapp' => 'nullable|string|max:15',
        'social_handle' => [
            'required', 'string',
            Rule::unique('national_d_b_user_profiles', 'social_handle')->ignore($this->route('id')),
        ],
        'address_home' => 'required|string',
        'nearest_busstop' => self::NULLABLE_STRING_MAX_255,
        'address_office' => self::REQUIRED_STRING_MAX_255,
        'industry' => self::NULLABLE_STRING_MAX_255,
        'next_of_kin' => 'required|string|max:50',
        'next_of_kin_phone' => 'nullable|string|max:15',
        'image_path' => 'nullable|file|mimes:pdf,jpg,png|max:2048',
        'ordination_category' => 'required|in:DEACON,DEACONESS,ASST PASTOR,FULL PASTOR',
    ];
}

}
