<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TodoListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

     private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
    private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';


    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
        'task' => 'required|string|max:255',
        'description' => self::REQUIRED_STRING_MAX_255,
        'assignee' => self::REQUIRED_STRING_MAX_255,
        'startDate' => self::REQUIRED_STRING_MAX_255,
        'dueDate' => self::REQUIRED_STRING_MAX_255,
        'status' => 'required|in:inProgress,inComplete,complete,clear',
        'priority' => 'required|in:urgent,high,normal,low,clear',
        'assigned' => 'boolean',
       ];
    }
}
