<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class NationalReportFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

     private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
    private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';

    private const REQUIRED_INTEGER_MAX_255 = 'required|int|max:255';

    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
            'core_duties' => 'required|string|max:255',
            'monthly_task' => self::REQUIRED_STRING_MAX_255,
            'task_done' => self::REQUIRED_STRING_MAX_255,
            'strength' => self::REQUIRED_STRING_MAX_255,
            'weakness' =>self::NULLABLE_STRING_MAX_255,
            'opportunities' =>self::NULLABLE_STRING_MAX_255,
            'threats' => self::NULLABLE_STRING_MAX_255,
            'amount_budgeted' => self::REQUIRED_STRING_MAX_255,
            'amount_spent' => self::REQUIRED_STRING_MAX_255,
            'remarks' => self::NULLABLE_STRING_MAX_255,

        ];
    }
}
