<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MonthlyDuePaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
    private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';

    //private const REQUIRED_INTEGER_MAX_255 = 'required|int|max:255';

    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
            'amount' => 'required|string|max:255',
            'province' => self::REQUIRED_STRING_MAX_255,
            'paymentDate' => 'required|string',
            'provinceCoordinator' => self::REQUIRED_STRING_MAX_255,
            'refMonth' => self::NULLABLE_STRING_MAX_255,
            'whoPaid' => self::NULLABLE_STRING_MAX_255,
            'remark' => self::NULLABLE_STRING_MAX_255,
        ];
    }
}
