<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\Rule;

class ConferenceFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

     // Define reusable constants
     private const STRING_MAX_100 = 'required|string|max:100';

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */

     public const ERROR_USER_EXIST = 'Email Already Used By Another Person or You!'; // ✅ Define constant
    public function rules(): array
    {

        return [
            'conference_date' => 'required|string',
            'conference_theme' => 'required|string|max:255',
            'full_name' => 'required|string|max:255',
            'email' => [
                'required',
                'email',
                Rule::unique('conferences', 'email'),
            ],
            'phone_number' => 'required|string|min:10|max:15',
            'state' => self::STRING_MAX_100,
            'region' => self::STRING_MAX_100,
            'province' => self::STRING_MAX_100,
            'position' => self::STRING_MAX_100,
            'accommodation' => 'boolean',
            'arrival_date' => 'nullable|string',
            'departure_date' => 'nullable|string',
            'first_timer' => 'boolean',
        ];
    }

    protected function failedValidation(Validator $validator)
{
    throw new HttpResponseException(response()->json([
        'error' => 'Validation Failed',
        'message' => $validator->errors(),
    ], 422));
   }

   public function messages(): array
    {
        return [
            'email.unique' => self::ERROR_USER_EXIST, // ✅ Custom error message for duplicate email
        ];
    }
}
