<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Http\Requests\TodoListRequest;
use App\Models\TodoList;
use Illuminate\Http\Request;

class TodoListController extends Controller
{
    public function index()
    {
        return response()->json(TodoList::all());
    }

    public function store(TodoListRequest $request)
    {
        $todo = TodoList::create($request->validated());
        return response()->json(['message' => 'Todo created successfully.', 'data' => $todo], 201);
    }

    public function show(string $id)
    {
        $todo = TodoList::findOrFail($id);
        return response()->json($todo);
    }

    public function update(TodoListRequest $request, string $id)
    {
        $todo = TodoList::findOrFail($id);
        $todo->update($request->validated());
        return response()->json(['message' => 'Todo updated successfully.', 'data' => $todo]);
    }

    public function destroy(string $id)
    {
        $todo = TodoList::findOrFail($id);
        $todo->delete();
        return response()->json(['message' => 'Todo deleted successfully.']);
    }

    // ✅ PATCH: /api/todos/{id}/status
    public function updateStatus(Request $request, string $id)
    {
        $request->validate([
            'status' => 'required|in:inProgress,inComplete,complete,clear',
        ]);

        $todo = TodoList::findOrFail($id);
        $todo->status = $request->status;
        $todo->save();

        return response()->json(['message' => 'Status updated.', 'status' => $todo->status]);
    }

    // ✅ PATCH: /api/todos/{id}/priority
    public function updatePriority(Request $request, string $id)
    {
        $request->validate([
            'priority' => 'required|in:urgent,high,normal,low,clear',
        ]);

        $todo = TodoList::findOrFail($id);
        $todo->priority = $request->priority;
        $todo->save();

        return response()->json(['message' => 'Priority updated.', 'priority' => $todo->priority]);
    }
}
