<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Http\Requests\SpecialProjectsReportRequest;
use App\Models\SpecialProjectsReport;
use Illuminate\Http\Request;

class SpecialProjectsReportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
        public function index()
        {
            $reports = SpecialProjectsReport::latest()->get();
            return response()->json($reports);
        }

        /**
         * Store a newly created resource in storage.
         */
        public function store(SpecialProjectsReportRequest $request)
        {
            $data = $request->validated();

            $report = SpecialProjectsReport::create($data);

                return response()->json([
                    'message' => 'Special Project Report Created Successfully.',
                    'data' => $report,
                ], 201);
        }

        /**
         * Display the specified resource.
         */
        public function show(string $id)
        {
            $report = SpecialProjectsReport::find($id);

            if (!$report) {
            return response()->json(['error' => 'Report Not Found'], 404);
                    }

            return response()->json($report, 200);
        }

        /**
         * Update the specified resource in storage.
         */
        public function update(SpecialProjectsReportRequest $request, string $id)
        {
            $report = SpecialProjectsReport::find($id);

                    if (!$report) {
                        return response()->json(['error' => 'Report Not Found'], 404);
                    }

                    $report->update($request->validated());

                    return response()->json([
                        'message' => 'Special Project Report Updated',
                        'data' => $report
                    ], 200);
        }

        /**
         * Remove the specified resource from storage.
         */
        public function destroy(string $id)
        {
            $report = SpecialProjectsReport::find($id);

                if (!$report) {
                    return response()->json(['error' => 'Report not found'], 404);
                }

                $report->delete();

                return response()->json(['message' => 'Special Project Report Deleted']);
        }
}
