<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Http\Requests\NationalReportFormRequest;
use App\Models\NationalReport;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class NationalReportController extends Controller
{
            /**
             * Display a listing of the resource.
             */
            // 🔍 GET all reports
            public function index(): JsonResponse
            {
                $reports = NationalReport::latest()->get();
                return response()->json($reports);
            }

            // 📝 POST create report
            public function store(NationalReportFormRequest $request): JsonResponse
        {
            $data = $request->validated();
            $data['created_date'] = now(); // Auto-generate current timestamp

            $report = NationalReport::create($data);

            return response()->json([
                'message' => 'National Report Created Successfully.',
                'data' => $report,
            ], 201);
        }


            // 🔍 GET single report
            public function show(string $id): JsonResponse
            {
                $report = NationalReport::find($id);

                if (!$report) {
                    return response()->json(['error' => 'Report Not Found'], 404);
                }

                return response()->json($report, 200);
            }

            // ✏️ PUT update report
            public function update(NationalReportFormRequest $request, string $id): JsonResponse
            {
                $report = NationalReport::find($id);

                if (!$report) {
                    return response()->json(['error' => 'Report Not Found'], 404);
                }

                $report->update($request->validated());

                return response()->json([
                    'message' => 'National Report Updated',
                    'data' => $report
                ], 200);
            }


            // ❌ DELETE report
            public function destroy(string $id): JsonResponse
        {
            $report = NationalReport::find($id);

            if (!$report) {
                return response()->json(['error' => 'Report not found'], 404);
            }

            $report->delete();

            return response()->json(['message' => 'Monthly Report Deleted']);
        }
}
